/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.datamodel.impl;

import com.ibm.hwmca.fw.servlet.pmod.PmDataBean;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.ExpressionEnabled;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmTableModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.table.PmCheckBoxCellInfo;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.table.PmComboBoxCellInfo;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.table.PmDateCellInfo;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.table.PmSimpleCellInfo;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.table.PmTableColumn;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.table.PmTableColumnModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.table.PmTextEntryCellInfo;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.table.PmTimeCellInfo;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.table.impl.EditableTableCellUpdate;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Hmc_ModelExpressionNode;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Node;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.auiml.Acvt_ColumnNode;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.auiml.Acvt_ComboBoxEntryNode;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.auiml.Acvt_RowNode;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.auimlcvt.auiml.AuimlJSPTools;
import com.ibm.hwmca.fw.util.auimlcvt.auiml.tags.TagUtils;
import com.ibm.ps.wcl.components.table.TableMarkupString;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.ItemDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MutableTableModelTreeImpl
implements PmTableModel,
ExpressionEnabled,
PmTableColumnModel {
    private static final String TRACE_MASKT = "XPMDTAMT";
    private static final String TRACE_MASKF = "XPMDTAMF";
    private Node modelRoot;
    private int[] selected = new int[0];
    private Map mapping;
    private List rows;
    private List columns;
    private PmTableColumn[] tableColumns;
    private int bindingType = 1;
    private static final int ROW_BOUND = 1;
    private static final int COLUMN_BOUND = 2;
    private boolean utmMaintainsDataMode = false;
    private static final Class[] CLASS_ARGS_GET_ROW_AT = new Class[]{Integer.TYPE};
    private static final Class[] CLASS_ARGS_SET_ROW_AT = new Class[]{Integer.TYPE, array$Lcom$ibm$ui$framework$ItemDescriptor == null ? (array$Lcom$ibm$ui$framework$ItemDescriptor = MutableTableModelTreeImpl.class$("[Lcom.ibm.ui.framework.ItemDescriptor;")) : array$Lcom$ibm$ui$framework$ItemDescriptor};
    private static final Class[] CLASS_ARGS_SET_SELECTION_INT = new Class[]{array$I == null ? (array$I = MutableTableModelTreeImpl.class$("[I")) : array$I};
    private static final Class[] CLASS_ARGS_SET_SELECTION_STRING = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = MutableTableModelTreeImpl.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
    private List editBits;
    static /* synthetic */ Class array$Lcom$ibm$ui$framework$ItemDescriptor;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$com$ibm$ps$wcl$core$markup$WImage;
    static /* synthetic */ Class class$java$lang$Object;

    public MutableTableModelTreeImpl(Node modelRoot) {
        Trace.trace(TRACE_MASKF, "MTMTI: <ctor> root node is: " + modelRoot);
        this.modelRoot = modelRoot;
        this.rows = new ArrayList();
        this.columns = new ArrayList();
        this.mapping = new HashMap();
        this.editBits = new ArrayList();
    }

    public String getModelId() {
        String id = this.modelRoot.getParent().fetchAttribute("hmc", "model", false, false);
        return id == null ? "" : id;
    }

    public void setUTMMaintainsDataMode(boolean utmMaintainsDataMode) {
        this.utmMaintainsDataMode = utmMaintainsDataMode;
    }

    public boolean isUTMMaintainsDataMode() {
        return this.utmMaintainsDataMode;
    }

    public void init() {
        Trace.trace(TRACE_MASKF, "MTMTI: init()");
        Iterator iterator = this.modelRoot.decendents().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == null || !(node instanceof Acvt_RowNode) && !(node instanceof Acvt_ColumnNode)) continue;
            if (node instanceof Acvt_RowNode) {
                Trace.trace(TRACE_MASKF, "MTMTI: Found a row definition entry ");
                this.bindingType = 1;
            } else if (node instanceof Acvt_ColumnNode) {
                Trace.trace(TRACE_MASKF, "MTMTI: Found a column definition entry");
                this.bindingType = 2;
            }
            this.columns.add(node);
        }
        Trace.trace(TRACE_MASKF, "MTMTI: Table appears to have " + this.columns.size() + " columns");
        this.initializeTableColumns();
        PmDataBean bean = this.modelRoot.getPanelModel().getDataBean();
        if (bean instanceof DataBean) {
            this.populateFromAuimlBean();
        }
    }

    private void initializeTableColumns() {
        this.tableColumns = new PmTableColumn[this.columns.size()];
        for (int i = 0; i < this.tableColumns.length; ++i) {
            String entrySize;
            PmSimpleCellInfo info;
            String style;
            Node columnNode = (Node)this.columns.get(i);
            String type = columnNode.getAttribute("type");
            if (type == null) {
                type = "";
            }
            if ((style = columnNode.getAttribute("style")) == null) {
                style = "";
            }
            if (type.equals("BOOLEAN")) {
                this.tableColumns[i] = new PmTableColumn();
                info = new PmCheckBoxCellInfo();
                String notify = columnNode.getAttribute("notifySelect");
                info.setImmediateNotification(notify.equalsIgnoreCase("TRUE"));
                this.tableColumns[i].setCellInfo(info);
                continue;
            }
            if (type.equals("TIME")) {
                this.tableColumns[i] = new PmTableColumn();
                this.tableColumns[i].setCellInfo(new PmTimeCellInfo());
                continue;
            }
            if (type.equals("DATE")) {
                this.tableColumns[i] = new PmTableColumn();
                this.tableColumns[i].setCellInfo(new PmDateCellInfo());
                continue;
            }
            if (style.equals("combobox")) {
                this.tableColumns[i] = new PmTableColumn();
                this.tableColumns[i].setCellInfo(new PmComboBoxCellInfo());
                List kids = columnNode.decendents();
                int kidsLength = kids.size();
                ArrayList<String> values = new ArrayList<String>();
                for (int j = 0; j < kidsLength; ++j) {
                    if (!(kids.get(j) instanceof Acvt_ComboBoxEntryNode)) continue;
                    values.add(((Acvt_ComboBoxEntryNode)kids.get(j)).fetchAttribute("acvt", "value", true));
                }
                Object[] valueArray = new String[values.size()];
                valueArray = values.toArray(valueArray);
                Trace.trace(TRACE_MASKF, "Added " + valueArray.length + " combobox values:");
                for (int j = 0; j < valueArray.length; ++j) {
                    Trace.trace(TRACE_MASKF, "valueArray[" + j + "]:" + (String)valueArray[j]);
                }
                ((PmComboBoxCellInfo)this.tableColumns[i].getCellInfo()).setValues(valueArray);
                continue;
            }
            if (!type.equals("STRING") && !type.equals("NUMBER") || columnNode.getAttribute("read-only") == null || !columnNode.getAttribute("read-only").equalsIgnoreCase("FALSE")) continue;
            this.tableColumns[i] = new PmTableColumn();
            info = new PmTextEntryCellInfo();
            String maxLength = columnNode.getAttribute("maxLength");
            if (maxLength != null && !maxLength.equals("")) {
                ((PmTextEntryCellInfo)info).setMaxLength(Integer.parseInt(maxLength));
            }
            if ((entrySize = columnNode.getAttribute("optimumLength")) != null && !entrySize.equals("")) {
                ((PmTextEntryCellInfo)info).setSize(Integer.parseInt(entrySize));
            }
            this.tableColumns[i].setCellInfo(info);
        }
    }

    public void setSelected(int[] selected) {
        Trace.trace(TRACE_MASKF, "MTMTI: setSelected()");
        this.selected = selected == null ? new int[0] : selected;
        PmDataBean bean = this.modelRoot.getPanelModel().getDataBean();
        if (bean instanceof DataBean) {
            this.setSelectionInToBean();
        }
    }

    public int[] getSelected() {
        Trace.trace(TRACE_MASKF, "MTMTI: getSelected() ");
        if (this.selected == null) {
            this.selected = new int[0];
        }
        return this.selected;
    }

    public void refresh() {
        Trace.trace(TRACE_MASKF, "MTMTI: refresh()");
        if (this.utmMaintainsDataMode) {
            Trace.trace(TRACE_MASKF, "MTMTI: UTM Maintains data -- ignoring refresh()");
        } else {
            this.rows.clear();
            this.mapping.clear();
            PmDataBean bean = this.modelRoot.getPanelModel().getDataBean();
            if (bean instanceof DataBean) {
                this.populateFromAuimlBean();
            }
        }
    }

    private void checkEditBitsRowCount(int numRows) {
        int editBitsSize = this.editBits.size();
        if (editBitsSize < numRows + 1) {
            int columnsSize = this.columns.size();
            BitSet bits = new BitSet(columnsSize);
            for (int i = 0; i < columnsSize; ++i) {
                Node columnNode = (Node)this.columns.get(i);
                String ro = columnNode.getAttribute("read-only");
                if (ro == null) {
                    ro = "";
                }
                if (ro.equals("TRUE")) continue;
                bits.set(i);
            }
            while (editBitsSize < numRows + 1) {
                this.editBits.add(bits.clone());
                ++editBitsSize;
            }
        }
    }

    private void populateFromAuimlBean() {
        Trace.trace(TRACE_MASKF, "MTMTI: populating from AUIML databean ");
        try {
            PmDataBean bean = this.modelRoot.getPanelModel().getDataBean();
            String hmcid = this.modelRoot.fetchAttribute("hmc", "binding_id", false);
            Trace.trace(TRACE_MASKF, "MTMTI:hmcid:" + hmcid);
            if (this.bindingType == 1) {
                Trace.trace(TRACE_MASKF, "MTMTI: AUIML table is row-bound");
                int numRows = 0;
                if (hmcid != null) {
                    Method getRowCount = bean.getClass().getMethod("get" + hmcid + "RowCount", null);
                    numRows = ((Number)getRowCount.invoke((Object)bean, null)).intValue();
                }
                Trace.trace(TRACE_MASKF, "MTMTI: AUIML databean has " + numRows + " rows");
                Method getRowAt = bean.getClass().getMethod("get" + hmcid + "RowAt", CLASS_ARGS_GET_ROW_AT);
                for (int i = 0; i < numRows; ++i) {
                    ItemDescriptor[] row = (ItemDescriptor[])getRowAt.invoke((Object)bean, new Integer(i));
                    if (row == null) continue;
                    for (int j = 0; j < row.length; ++j) {
                        if (row[j] == null) continue;
                        Trace.trace(TRACE_MASKF, "MTMTI: " + row[j].getName() + " : " + row[j].getTitle() + " : " + i + " : " + j);
                        this.setValueAt(row[j].getTitle(), i, j);
                        this.mapping.put(row[j].getName(), new MapData(row[j].getTitle(), i, j));
                    }
                }
                Method getSelection = bean.getClass().getMethod("get" + hmcid + "Selection", null);
                this.selected = (int[])getSelection.invoke((Object)bean, null);
                Trace.trace(TRACE_MASKF, "MTMTI: get selected for row-bound table: " + this.selected);
                if (this.selected != null) {
                    for (int i = 0; i < this.selected.length; ++i) {
                        Trace.trace(TRACE_MASKF, "MTMTI: selected[" + i + "]: " + this.selected[i]);
                    }
                } else {
                    this.selected = new int[0];
                }
            } else if (this.bindingType == 2) {
                Trace.trace(TRACE_MASKF, "MTMTI: AUIML table is column-bound");
                int numCols = this.columns.size();
                Object aCol = null;
                String aColId = null;
                for (int j = 0; j < numCols; ++j) {
                    Method getList;
                    ItemDescriptor[] col;
                    String columnid = ((Node)this.columns.get(j)).fetchAttribute("acvt", "binding_id", false);
                    if (columnid == null || (col = (ItemDescriptor[])(getList = bean.getClass().getMethod("get" + columnid + "List", null)).invoke((Object)bean, null)) == null) continue;
                    aCol = null;
                    aColId = columnid;
                    for (int i = 0; i < col.length; ++i) {
                        if (col[i] == null) continue;
                        this.setValueAt(col[i].getTitle(), i, j);
                        this.mapping.put(col[i].getName(), new MapData(col[i].getTitle(), i, j));
                    }
                }
                if (aCol != null) {
                    Method getSelection = bean.getClass().getMethod("get" + aColId + "Selection", null);
                    String[] selectedStrings = (String[])getSelection.invoke((Object)bean, null);
                    if (selectedStrings != null) {
                        int i;
                        this.selected = new int[selectedStrings.length];
                        for (i = 0; i < selectedStrings.length; ++i) {
                            if (selectedStrings[i] == null) continue;
                            for (int j = 0; j < (aCol).length; ++j) {
                                if (aCol[j] == null || !aCol[j].getName().equals(selectedStrings[i])) continue;
                                this.selected[i] = j;
                                j = (aCol).length;
                            }
                        }
                        Trace.trace(TRACE_MASKF, "MTMTI: get selected for column-bound table: " + this.selected);
                        if (this.selected != null) {
                            for (i = 0; i < this.selected.length; ++i) {
                                Trace.trace(TRACE_MASKF, "MTMTI: selected[" + i + "]: " + this.selected[i]);
                            }
                        }
                    } else {
                        this.selected = new int[0];
                    }
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "MTMTI: Exception in populate auiml databean method: " + e.getMessage());
            Trace.trace(TRACE_MASKT, e);
        }
    }

    private void setSelectionInToBean() {
        try {
            PmDataBean bean = this.modelRoot.getPanelModel().getDataBean();
            String hmcid = this.modelRoot.fetchAttribute("hmc", "binding_id", false);
            Trace.trace(TRACE_MASKF, "MTMTI:hmcid:" + hmcid);
            if (this.bindingType == 1) {
                Trace.trace(TRACE_MASKF, "MTMTI: AUIML table is row-bound");
                if (hmcid != null) {
                    Trace.trace(TRACE_MASKF, "looking up method: " + bean.getClass().getName() + ".set" + hmcid + "Selection");
                    Method setSelection = bean.getClass().getMethod("set" + hmcid + "Selection", CLASS_ARGS_SET_SELECTION_INT);
                    Trace.trace(TRACE_MASKF, "about to store selection");
                    setSelection.invoke((Object)bean, new Object[]{this.getSelected()});
                    Trace.trace(TRACE_MASKF, "stored selection");
                }
            } else if (this.bindingType == 2) {
                Trace.trace(TRACE_MASKF, "MTMTI: AUIML table is column-bound");
                int numCols = this.columns.size();
                for (int j = 0; j < numCols; ++j) {
                    String columnid = ((Node)this.columns.get(j)).fetchAttribute("acvt", "binding_id", false);
                    if (columnid == null) continue;
                    Method getList = bean.getClass().getMethod("get" + columnid + "List", null);
                    ItemDescriptor[] col = (ItemDescriptor[])getList.invoke((Object)bean, null);
                    String[] selectedNames = new String[this.getSelected().length];
                    if (col != null) {
                        for (int i = 0; i < this.selected.length; ++i) {
                            if (col[this.selected[i]] == null) continue;
                            selectedNames[i] = col[this.selected[i]].getName();
                        }
                    }
                    Trace.trace(TRACE_MASKF, "looking up method: " + bean.getClass().getName() + ".set" + hmcid + "Selection");
                    Method setSelection = bean.getClass().getMethod("set" + hmcid + "Selection", CLASS_ARGS_SET_SELECTION_STRING);
                    Trace.trace(TRACE_MASKF, "about to store selection");
                    setSelection.invoke((Object)bean, new Object[]{selectedNames});
                    Trace.trace(TRACE_MASKF, "stored selection");
                }
            }
        }
        catch (NoSuchMethodException nsme) {
            Trace.trace(TRACE_MASKF, "No such method exception in setSelectionIntoBean(): " + nsme.getMessage());
        }
        catch (IllegalAccessException iae) {
            Trace.trace(TRACE_MASKF, "Illegal access exception in setSelectionIntoBean(): " + iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            Trace.trace(TRACE_MASKF, "Invocation target exception in setSelectionIntoBean(): " + ite.getMessage());
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error seting AUIML databean selection in setSelectionIntoBean(): " + e.getMessage());
        }
    }

    public Class getColumnClass(int columnIndex) throws IllegalArgumentException {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            throw new IllegalArgumentException("Index specified is invalid: " + columnIndex);
        }
        Node columnNode = (Node)this.columns.get(columnIndex);
        String type = columnNode.getAttribute("type");
        if (type.equals("STRING")) {
            return class$java$lang$String == null ? (class$java$lang$String = MutableTableModelTreeImpl.class$("java.lang.String")) : class$java$lang$String;
        }
        if (type.equals("NUMBER")) {
            return class$java$lang$Double == null ? (class$java$lang$Double = MutableTableModelTreeImpl.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (type.equals("BOOLEAN")) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = MutableTableModelTreeImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (type.equals("DATE")) {
            return class$java$util$Date == null ? (class$java$util$Date = MutableTableModelTreeImpl.class$("java.util.Date")) : class$java$util$Date;
        }
        if (type.equals("TIME")) {
            return class$java$util$Date == null ? (class$java$util$Date = MutableTableModelTreeImpl.class$("java.util.Date")) : class$java$util$Date;
        }
        if (type.equals("IMAGE")) {
            return class$com$ibm$ps$wcl$core$markup$WImage == null ? (class$com$ibm$ps$wcl$core$markup$WImage = MutableTableModelTreeImpl.class$("com.ibm.ps.wcl.core.markup.WImage")) : class$com$ibm$ps$wcl$core$markup$WImage;
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = MutableTableModelTreeImpl.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Trace.trace(TRACE_MASKF, "MTMTI: setValueAt(" + aValue + "," + rowIndex + "," + columnIndex + ")");
        boolean isEditableCellUpdate = aValue instanceof EditableTableCellUpdate;
        if (isEditableCellUpdate) {
            aValue = ((EditableTableCellUpdate)aValue).getNewValue();
        }
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            throw new IllegalArgumentException("Column Index specified is invalid: " + columnIndex);
        }
        int numRows = this.rows.size();
        int numCols = this.columns.size();
        for (int i = numRows; i <= rowIndex; ++i) {
            ArrayList<Object> row = new ArrayList<Object>(numCols);
            for (int j = 0; j < numCols; ++j) {
                row.add(null);
            }
            this.rows.add(row);
        }
        this.checkEditBitsRowCount(rowIndex);
        if (this.getColumnClass(columnIndex).equals(class$java$lang$String == null ? (class$java$lang$String = MutableTableModelTreeImpl.class$("java.lang.String")) : class$java$lang$String) && ((Node)this.columns.get(columnIndex)).getAttribute("fixedFont").equals("TRUE") && aValue instanceof String) {
            String str = (String)aValue;
            ((List)this.rows.get(rowIndex)).set(columnIndex, new TableMarkupString("<label style=\"font-family:monospace;white-space:pre\">" + str + "</label>", str));
        } else if (this.getColumnClass(columnIndex).equals(class$com$ibm$ps$wcl$core$markup$WImage == null ? (class$com$ibm$ps$wcl$core$markup$WImage = MutableTableModelTreeImpl.class$("com.ibm.ps.wcl.core.markup.WImage")) : class$com$ibm$ps$wcl$core$markup$WImage) && aValue instanceof String) {
            String str = (String)aValue;
            ((List)this.rows.get(rowIndex)).set(columnIndex, new TableMarkupString("<img src=\"" + TagUtils.adjustImageSrcPath(str) + "\"/>", TagUtils.adjustImageSrcPath(str)));
        } else if (this.getColumnClass(columnIndex).equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = MutableTableModelTreeImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean) && aValue instanceof String) {
            ((List)this.rows.get(rowIndex)).set(columnIndex, Boolean.valueOf((String)aValue));
        } else {
            ((List)this.rows.get(rowIndex)).set(columnIndex, aValue);
        }
        if (isEditableCellUpdate) {
            this.setRowInToBean(rowIndex);
        }
    }

    private void setRowInToBean(int rowIndex) {
        try {
            PmDataBean bean = this.modelRoot.getPanelModel().getDataBean();
            String hmcid = this.modelRoot.fetchAttribute("hmc", "binding_id", false);
            Trace.trace(TRACE_MASKF, "MTMTI:hmcid:" + hmcid);
            if (this.bindingType == 1) {
                if (hmcid != null) {
                    Method getRowAt = bean.getClass().getMethod("get" + hmcid + "RowAt", CLASS_ARGS_GET_ROW_AT);
                    ItemDescriptor[] row = (ItemDescriptor[])getRowAt.invoke((Object)bean, new Integer(rowIndex));
                    Method setRowAt = bean.getClass().getMethod("set" + hmcid + "RowAt", CLASS_ARGS_SET_ROW_AT);
                    ItemDescriptor[] rowData = new ItemDescriptor[this.getColumnCount()];
                    for (int i = 0; i < rowData.length; ++i) {
                        Object value = ((List)this.rows.get(rowIndex)).get(i);
                        rowData[i] = new ItemDescriptor(row[i].getName(), ((List)this.rows.get(rowIndex)).get(i).toString());
                    }
                    setRowAt.invoke((Object)bean, new Integer(rowIndex), rowData);
                }
            } else {
                Trace.trace(TRACE_MASKF, "MTMTI: AUIML table is column-bound : UNSUPPORTED for now");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "MTMTI: Exception in setting row data in to bean method: " + e.getMessage());
            Trace.trace(TRACE_MASKT, e);
        }
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            throw new IllegalArgumentException("Index specified is invalid: " + columnIndex);
        }
        Node columnNode = (Node)this.columns.get(columnIndex);
        String caption = columnNode.getAttribute("evalCaption");
        if (caption == null) {
            caption = "";
        }
        return caption;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            throw new IllegalArgumentException("Row index specified is invalid: " + rowIndex);
        }
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            throw new IllegalArgumentException("Column index specified is invalid: " + columnIndex);
        }
        Object val = ((List)this.rows.get(rowIndex)).get(columnIndex);
        if (val != null && this.getColumnClass(columnIndex).equals(class$java$lang$String == null ? (class$java$lang$String = MutableTableModelTreeImpl.class$("java.lang.String")) : class$java$lang$String) && val.toString().toUpperCase().indexOf("<HTML>") >= 0) {
            val = AuimlJSPTools.cleanupResource(val.toString());
            val = new TableMarkupString(val.toString(), val.toString());
        }
        return val;
    }

    public boolean containsHmcId(String id) {
        if (id == null || id.trim().equals("")) {
            throw new IllegalArgumentException("hmc:id must not be null or the empty string");
        }
        if (this.columns != null) {
            Trace.trace(TRACE_MASKF, "MTMTI: Checking for hmc:id in table columns (" + id + ")");
            Iterator iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                String tmpId = node.fetchAttribute("hmc", "id", false, false);
                if (tmpId == null || !tmpId.equals(id)) continue;
                Trace.trace(TRACE_MASKF, "MTMTI: found hmc:id");
                return true;
            }
        }
        return this.mapping.containsKey(id);
    }

    public boolean containsColumnHeaderId(String id) {
        if (id == null || id.trim().equals("")) {
            throw new IllegalArgumentException("hmc:id must not be null or the empty string");
        }
        if (this.columns != null) {
            Trace.trace(TRACE_MASKF, "MTMTI: Checking for hmc:id in table columns (" + id + ")");
            Iterator iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                String tmpId = node.fetchAttribute("hmc", "id", false, false);
                if (tmpId == null || !tmpId.equals(id)) continue;
                Trace.trace(TRACE_MASKF, "MTMTI: found hmc:id");
                return true;
            }
        }
        return false;
    }

    public void setColumnCaption(String id, String text) {
        if (id == null || id.trim().equals("")) {
            throw new IllegalArgumentException("hmc:id must not be null or the empty string");
        }
        if (!this.containsColumnHeaderId(id)) {
            throw new IllegalArgumentException("Column header with hmc:id='" + id + "' does not exist");
        }
        if (this.columns != null) {
            for (int i = 0; i < this.columns.size(); ++i) {
                String tmpId = ((Node)this.columns.get(i)).fetchAttribute("hmc", "id", false, false);
                if (tmpId == null || !tmpId.equals(id)) continue;
                ((Node)this.columns.get(i)).setAttribute("acvt", "caption", text);
            }
        }
    }

    public Object getValueByHmcId(String id) {
        MapData data = (MapData)this.mapping.get(id);
        return data == null ? null : data.value;
    }

    public int getRowIndexByHmcId(String id) {
        MapData data = (MapData)this.mapping.get(id);
        return data == null ? -1 : data.row;
    }

    public int getColumnIndexByHmcId(String id) {
        MapData data = (MapData)this.mapping.get(id);
        return data == null ? -1 : data.column;
    }

    public void removeRow(int index) {
        if (index < 0 || index >= this.rows.size()) {
            throw new IllegalArgumentException("Index specified is invalid: " + index);
        }
        Trace.trace(TRACE_MASKF, "MTMTI: removeRow(" + index + ")");
        this.rows.remove(index);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || columnIndex < 0) {
            throw new IllegalArgumentException("Row index and column index must both be greater than or equal to zero");
        }
        if (rowIndex > this.editBits.size()) {
            throw new IllegalArgumentException("Row index " + rowIndex + " is greater than the number of rows in the table");
        }
        if (columnIndex > this.columns.size()) {
            throw new IllegalArgumentException("Column index " + columnIndex + " is greater than the number of columns in the table");
        }
        String ro = this.modelRoot.getAttribute("read-only");
        if (ro == null) {
            ro = "";
        }
        if (ro.equals("TRUE")) {
            return false;
        }
        BitSet row = (BitSet)this.editBits.get(rowIndex);
        return row.get(columnIndex);
    }

    public void setCellEditable(int rowIndex, int columnIndex, boolean state) {
        Trace.trace(TRACE_MASKF, "MTMTI: setCellEditable(" + rowIndex + "," + columnIndex + "," + state + ")");
        if (rowIndex < 0 || columnIndex < 0) {
            throw new IllegalArgumentException("Row index and column index must both be greater than or equal to zero");
        }
        if (rowIndex > this.editBits.size()) {
            throw new IllegalArgumentException("Row index " + rowIndex + " is greater than the number of rows in the table");
        }
        if (columnIndex > this.columns.size()) {
            throw new IllegalArgumentException("Column index " + columnIndex + " is greater than the number of columns in the table");
        }
        if (state) {
            ((BitSet)this.editBits.get(rowIndex)).set(columnIndex);
        } else {
            ((BitSet)this.editBits.get(rowIndex)).clear(columnIndex);
        }
    }

    public Hmc_ModelExpressionNode[] getExpressionNodes() {
        Node wtableNode = this.modelRoot.getParent();
        Hmc_ModelExpressionNode[] nodes = new Hmc_ModelExpressionNode[this.columns.size()];
        for (int i = 0; i < nodes.length; ++i) {
            Properties p = new Properties();
            p.put("modelType", "table");
            p.put("modelID", this.getModelId());
            Node col = (Node)this.columns.get(i);
            String colCaption = col.fetchAttribute("acvt", "caption", false, false);
            p.put("text", colCaption == null ? "" : colCaption);
            p.put("index", new Integer(i).toString());
            nodes[i] = new Hmc_ModelExpressionNode(null, p);
            wtableNode.getParent().addChild(nodes[i], wtableNode.getId());
        }
        return nodes;
    }

    public void setExpression(String text, int index) {
        Node col = (Node)this.columns.get(index);
        col.setAttribute("evalCaption", text);
    }

    public PmTableColumn getColumn(String tableName, int columnIndex) {
        if (tableName == null || !this.getModelId().equals(tableName)) {
            return null;
        }
        if (columnIndex > this.tableColumns.length) {
            throw new IllegalArgumentException("Column index " + columnIndex + " is greater than the number of table columns (" + this.tableColumns.length + ")");
        }
        return this.tableColumns[columnIndex];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MapData {
        public Object value;
        public int row;
        public int column;

        public MapData(Object value, int row, int column) {
            this.value = value;
            this.row = row;
            this.column = column;
        }
    }
}

